/**********
* File: CDGL_IDirect3DIndexBuffer9.h

* Brief Description: This file contains the declaration of the class CDGL_IDirect3DIndexBuffer9. 
					 This class is equivalent to IDirect3DIndexBuffer9 interface in Direct3D9. IDirect3DIndexBuffer9 is made as an abstract class in d3d9.h (DXInclude)file.

* Written By: Shilpa Prabhu

* Copyright: 1994-2004 by Robosoft Technologies, all rights reserved.

* Date Of Creation: 27Oct04

* Change History (Most Recent First):

**********/

#ifndef __CDGL_IDIRECT3DINDEXBUFFER9_H_
#define __CDGL_IDIRECT3DINDEXBUFFER9_H_

#include <Carbon/Carbon.h>

#ifndef LIB_CHANGES
#include "OZone/IIndexBuffer.h"
#include "OZone/GraphicsInit.h"
#else
#include "IIndexBuffer.h"
#include "GraphicsInit.h"
#endif	// LIB_CHANGES

#include "d3d9.h"

class CDGL_IDirect3DIndexBuffer9 : public IDirect3DIndexBuffer9
{
	public:		
		
		CDGL_IDirect3DIndexBuffer9(IDirect3DDevice9 *pDevice, UINT Length, DWORD Usage, DWORD FVF, D3DPOOL pool);
		~CDGL_IDirect3DIndexBuffer9();
		
		//! IUnknown methods
		ULONG AddRef();
		HRESULT QueryInterface(REFIID riid, void **ppvObj);
		ULONG Release();
		
		//! IDirect3DResource9 methods
		HRESULT FreePrivateData(REFGUID refguid);
		HRESULT GetDevice(IDirect3DDevice9 **pDevice);
		DWORD GetPriority();
		HRESULT GetPrivateData(REFGUID refguid, void *pData, DWORD *pSizeOfData);
		D3DRESOURCETYPE GetType();
		void PreLoad();
		DWORD SetPriority(DWORD PriorityNew);
		HRESULT SetPrivateData(REFGUID refguid, CONST void *pData, DWORD SizeOfData, DWORD Flags);
		
		//! IDirect3DIndexBuffer9 methods
		HRESULT GetDesc(D3DINDEXBUFFER_DESC *pDesc);
		HRESULT Lock(UINT OffsetToLock, UINT SizeToLock, void **ppbData, DWORD Flags);
		HRESULT Unlock();
		
		//! Additional methods
		int		GetFmt(){return m_dwFVF;} 
		BYTE*   GetIndexBuffer() { return m_pIndex; }
		
		// Baaaalaaaa
		IIndexBuffer  GetSmartBuffer();
	
	private:
		
		IDirect3DDevice9	*	m_pDevice;
		BYTE				*   m_pIndex;
		UINT					m_lLength;
		DWORD					m_dwUsage;
		DWORD					m_dwFVF;
		DWORD					m_dwPriority;
		D3DPOOL					m_pool;
		int						m_lRefCount;
	
		// Baaaalaaaa
		IIndexBuffer 			mIndexBuffer;
	
};

#endif //__CDGL_IDIRECT3DINDEXBUFFER9_H_